/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.VWProcessEditMenu;
import filenet.vw.toolkit.design.mapui.VWDesignerMapListCellRenderer;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.design.mapui.resources.VWResource;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.uicontrols.VWIconButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;

public class VWDesignerMapToolbar
extends VWBaseMapToolbar
implements ActionListener {
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWBaseStepPalettePanel m_stepPalettePanel = null;
    protected IVWProcessCanvasPanel m_processCanvasPanel = null;
    protected AbstractButton m_newMapButton = null;
    protected AbstractButton m_deleteMapButton = null;
    protected VWIconButton m_editButton = null;
    protected VWProcessEditMenu m_editMenu = null;
    protected AbstractButton m_helpButton = null;

    public VWDesignerMapToolbar(VWDesignerWorkflowPane workflowPane, VWBaseStepPalettePanel stepPalettePanel, IVWProcessCanvasPanel processCanvasPanel) {
        super(workflowPane);
        this.m_stepPalettePanel = stepPalettePanel;
        this.m_processCanvasPanel = processCanvasPanel;
        this.m_authPropertyData = processCanvasPanel.getAuthPropertyData();
    }

    public void setViewOnly(boolean bViewOnly) {
        bViewOnly = !bViewOnly;
        boolean bDisplayFullBPMFunctionality = ((VWDesignerWorkflowPane)this.m_workflowPane).getSessionInfo().getDisplayFullBPMFunctionality();
        this.m_newMapButton.setVisible(bViewOnly && bDisplayFullBPMFunctionality);
        this.m_deleteMapButton.setVisible(bViewOnly);
    }

    public void init() {
        this.init(5);
        this.m_editMenu = new VWProcessEditMenu(this.m_processCanvasPanel);
    }

    public void removeReferences() {
        if (this.m_newMapButton != null) {
            this.m_newMapButton.removeActionListener(this);
            this.m_newMapButton.removeAll();
            this.m_newMapButton = null;
        }
        if (this.m_deleteMapButton != null) {
            this.m_deleteMapButton.removeActionListener(this);
            this.m_deleteMapButton.removeAll();
            this.m_deleteMapButton = null;
        }
        if (this.m_editButton != null) {
            this.m_editButton.removeActionListener(this);
            this.m_editButton.removeAll();
            this.m_editButton = null;
        }
        if (this.m_editMenu != null) {
            this.m_editMenu.releaseReferences();
            this.m_editMenu = null;
        }
        if (this.m_stepPalettePanel != null) {
            this.m_stepPalettePanel.releaseReferences();
            this.m_stepPalettePanel = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_authPropertyData = null;
        this.m_processCanvasPanel = null;
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_newMapButton)) {
            this.performNewMap(event);
        } else if (source.equals(this.m_deleteMapButton)) {
            this.performDeleteMap(event);
        } else if (source.equals(this.m_editButton)) {
            if (this.m_editMenu != null) {
                this.m_editMenu.show(this.m_editButton, 0, this.m_editButton.getHeight());
            }
        } else if (source.equals(this.m_helpButton)) {
            if (this.m_authPropertyData.getDesignerCoreData().getApplicationMode() == 0) {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh127.htm");
            } else {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh126.htm");
            }
        } else {
            super.actionPerformed(event);
        }
    }

    protected void init(int flags) {
        try {
            JMenuBar helpMenuBar;
            this.setLayout(new BoxLayout(this, 2));
            this.m_mapCombo = new JComboBox();
            this.m_mapCombo.setName("m_mapCombo_VWBaseMapToolbar");
            this.m_mapCombo.setRenderer(new VWDesignerMapListCellRenderer(this.m_authPropertyData));
            this.m_mapCombo.addItemListener(this);
            this.m_mapCombo.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, this.getBackground()));
            this.add(this.m_mapCombo);
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.m_newMapButton = VWImageLoader.createToolBarButton("newmap.gif", VWResource.s_createSubmap, false);
            this.m_newMapButton.setName("m_newMapButton_VWBaseMapToolbar");
            this.m_newMapButton.addActionListener(this);
            this.add(this.m_newMapButton);
            this.m_deleteMapButton = VWImageLoader.createToolBarButton("deletemap.gif", VWResource.s_deleteCurrentSubmap, false);
            this.m_deleteMapButton.setName("m_deleteMapButton_VWBaseMapToolbar");
            this.m_deleteMapButton.addActionListener(this);
            this.add(this.m_deleteMapButton);
            this.add(Box.createRigidArea(new Dimension(2, 0)));
            this.add(new JLabel(VWImageLoader.createImageIcon("tbseparator.gif")));
            this.add(Box.createRigidArea(new Dimension(6, 0)));
            this.m_editButton = new VWIconButton(VWResource.s_stepsStr, "toolbar_edit.gif");
            this.m_editButton.setName("m_editButton_VWBaseMapToolbar");
            this.m_editButton.addActionListener(this);
            this.add(this.m_editButton);
            if (this.m_stepPalettePanel != null) {
                this.add(Box.createRigidArea(new Dimension(11, 0)));
                this.m_stepPalettePanel.initialize(this.m_authPropertyData, this);
            }
            if ((helpMenuBar = this.getHelpMenuBar()) != null) {
                this.add(helpMenuBar);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performMapSelectionChanged(Object vwMap) {
        if (vwMap != null && this.m_workflowPane != null) {
            String mapName = ((VWMap)vwMap).getName();
            boolean bIsEditable = this.m_workflowPane.getMapCache().isEditable(mapName);
            if (this.m_authPropertyData != null) {
                this.m_authPropertyData.setCurrentMapEditable(bIsEditable);
            }
            super.performMapSelectionChanged(vwMap);
            this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 502, mapName);
            this.m_workflowPane.displayMap(vwMap);
        }
    }

    protected void updateButtonStates(Object selectedMap) {
        super.updateButtonStates(selectedMap);
        if (this.m_workflowPane != null && this.m_deleteMapButton != null && selectedMap != null && selectedMap instanceof VWMap) {
            VWMap map;
            String mapName = ((VWMap)selectedMap).getName();
            VWMapCache mapCache = this.m_workflowPane.getMapCache();
            boolean bCanDelete = mapCache.isEditable(mapName);
            if (bCanDelete && VWStringUtils.compare(mapName, "Workflow") == 0 && (map = mapCache.getBaseMap("Workflow")) == null) {
                bCanDelete = false;
            }
            this.m_deleteMapButton.setEnabled(bCanDelete);
        }
    }

    protected void performNewMap(ActionEvent event) {
        this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 500);
    }

    protected void performDeleteMap(ActionEvent event) {
        this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 501);
    }

    private JMenuBar getHelpMenuBar() {
        try {
            JMenuBar helpMenuBar = new JMenuBar();
            helpMenuBar.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 22;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(1, 1, 1, 1);
            helpMenuBar.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_helpButton = VWImageLoader.createToolBarButton("help20.gif", VWResource.s_help, false);
            this.m_helpButton.setName("m_helpButton_VWBaseMapToolbar");
            this.m_helpButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_helpButton);
            helpMenuBar.add(this.m_helpButton);
            return helpMenuBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

